﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Xml.Linq;

namespace LINQ_to_DataSet__SQL_Server_
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            // TODO: This line of code loads data into the 'telefonyDataSet.ListaOsob' table. You can move, or remove it, as needed.
            this.listaOsobTableAdapter.Fill(this.telefonyDataSet.ListaOsob);

        }

        private void button1_Click(object sender, EventArgs e)
        {
            //tam
            var listaOsobPelnoletnich = from osoba in telefonyDataSet.ListaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Nazwisko, osoba.Imię
                                        select osoba;

            //z powrotem
            DataTable dt = listaOsobPelnoletnich.CopyToDataTable();
            dt.TableName = "ListaOsobPelnoletnich";

            string s = "Kolumny tabeli:\n";
            foreach (var kolumna in dt.Columns) s += kolumna.ToString() + "\n";
            MessageBox.Show(s);

            //z powrotem
            telefonyDataSet.Tables.Add(dt);

            s = "Nazwy tabel:\n";
            foreach (var tabela in telefonyDataSet.Tables) s += tabela.ToString() + "\n";
            MessageBox.Show(s);
        }

        class Osoba
        {
            public int Id;
            public string Imię, Nazwisko;
            public int NumerTelefonu;
            public int Wiek;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //tam
            var listaOsobPelnoletnich = from osoba in telefonyDataSet.ListaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Nazwisko, osoba.Imię
                                        select new Osoba
                                        {
                                            Id = osoba.Id,
                                            Imię = osoba.Imię,
                                            Nazwisko = osoba.Nazwisko,
                                            NumerTelefonu = osoba.NumerTelefonu,
                                            Wiek = osoba.Wiek
                                        };

            //z powrotem

            //projektowanie tabeli
            DataTable dt = new DataTable("ListaOsobPelnoletnich");
            Osoba first = listaOsobPelnoletnich.First();
            DataColumn dcId = new DataColumn("Id");
            dcId.AllowDBNull = false;
            dcId.DataType = first.Id.GetType();
            DataColumn dcImię = new DataColumn("Imię");
            dcImię.DataType = first.Imię.GetType();
            DataColumn dcNazwisko = new DataColumn("Nazwisko");
            dcNazwisko.DataType = first.Nazwisko.GetType();
            DataColumn dcNumerTelefonu = new DataColumn("NumerTelefonu");
            dcNumerTelefonu.DataType = first.NumerTelefonu.GetType();
            DataColumn dcWiek = new DataColumn("Wiek");
            dcWiek.DataType = first.Wiek.GetType();

            dt.Columns.Add(dcId);
            dt.Columns.Add(dcImię);
            dt.Columns.Add(dcNazwisko);
            dt.Columns.Add(dcNumerTelefonu);
            dt.Columns.Add(dcWiek);

            //zapelnianie tabeli danymi
            foreach (Osoba osoba in listaOsobPelnoletnich)
            {
                DataRow dr = dt.NewRow();
                dr["Id"] = osoba.Id;
                dr["Imię"] = osoba.Imię;
                dr["Nazwisko"] = osoba.Nazwisko;
                dr["NumerTelefonu"] = osoba.NumerTelefonu;
                dr["Wiek"] = osoba.Wiek;
                dt.Rows.Add(dr);
            }

            string s = "Kolumny tabeli:\n";
            foreach (var kolumna in dt.Columns) s += kolumna.ToString() + "\n";
            MessageBox.Show(s);

            telefonyDataSet.Tables.Add(dt);

            s = "Nazwy tabel:\n";
            foreach (var tabela in telefonyDataSet.Tables) s += tabela.ToString() + "\n";
            MessageBox.Show(s);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            DataTable dt = telefonyDataSet.ListaOsob;
            int iloscOsobPelnoletnich = dt.AsEnumerable().Count(dr => dr.Field<int>("Wiek") > 18);

            double sredniWiek = dt.AsEnumerable().Average(osoba => osoba.Field<int>("Wiek"));

            var listaKobiet = from osoba in telefonyDataSet.ListaOsob
                              where osoba.Imię.EndsWith("a")
                              orderby -osoba.Nazwisko.Length
                              select new
                              {
                                  Id = osoba.Id,
                                  Imię = osoba.Imię,
                                  Nazwisko = osoba.Nazwisko,
                                  NumerTelefonu = osoba.NumerTelefonu,
                                  Wiek = osoba.Wiek
                              };
        }

        private void button4_Click(object sender, EventArgs e)
        {
            XDocument xml = new XDocument(
                new XDeclaration("1.0", "utf-8", "yes"),
                new XElement("ListaOsob",
                    from osoba in telefonyDataSet.ListaOsob
                    orderby osoba.Wiek
                    select new XElement("Osoba",
                        new XAttribute("Id", osoba.Id),
                        new XElement("Imię", osoba.Imię),
                        new XElement("Nazwisko", osoba.Nazwisko),
                        new XElement("NumerTelefonu", osoba.NumerTelefonu),
                        new XElement("Wiek", osoba.Wiek)
                    )
                )
            );

            xml.Save("ListaOsob.xml");
        }

        private void button5_Click(object sender, EventArgs e)
        {
            //pobieranie danych
            XDocument xml = XDocument.Load("ListaOsob.xml");
            IEnumerable<Osoba> listaOsobPelnoletnich =
               from osoba in xml.Descendants("Osoba")
               where int.Parse(osoba.Element("Wiek").Value) >= 18
               orderby osoba.Element("Imię").Value
               select
                  new Osoba()
                  {
                      Id = int.Parse(osoba.Attribute("Id").Value),
                      Imię = osoba.Element("Imię").Value,
                      Nazwisko = osoba.Element("Nazwisko").Value,
                      NumerTelefonu = int.Parse(osoba.Element("NumerTelefonu").Value),
                      Wiek = int.Parse(osoba.Element("Wiek").Value)
                  };

            //wyświetlanie danych
            string s = "Lista osób pełnoletnich:\n";
            foreach (Osoba osoba in listaOsobPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);
        }

        private void button6_Click(object sender, EventArgs e)
        {
            //pobieranie danych
            XDocument xml = XDocument.Load("ListaOsob.xml");
            IEnumerable<string> listaOsobPelnoletnich =
               from osoba in xml.Descendants("Osoba")
               where int.Parse(osoba.Element("Wiek").Value) >= 18
               orderby osoba.Element("Imię").Value
               select osoba.Element("Imię").Value + " " + osoba.Element("Nazwisko").Value;

            //wyświetlanie danych
            string s = "Lista osób pełnoletnich:\n";
            foreach (string personalia in listaOsobPelnoletnich) s += personalia + "\n";
            MessageBox.Show(s);
        }

        private void button7_Click(object sender, EventArgs e)
        {
            XDocument xml = XDocument.Load("ListaOsob.xml");
            IEnumerable<XElement> listaOsob = xml.Descendants("Osoba").Where(osoba => (osoba.Element("Imię").Value == "Bartosz" && osoba.Element("Nazwisko").Value == "Matulewski"));
            if (listaOsob.Count() > 0) listaOsob.First().Element("Wiek").Value = (int.Parse(listaOsob.First().Element("Wiek").Value) + 1).ToString();
            else
            {
                MessageBox.Show("Brak osób o podanym imieniu i nazwisku");
                return;
            }
            xml.Save("ListaOsob.xml");
        }
    }
}
